<?php

namespace Osteo_Accordion\Widgets;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Widget_Base;

defined( 'ABSPATH' ) || die();

class Osteo_Accordion extends Widget_Base {

    public function get_name() {
        return "Osteo_Accordion";
    }

    public function get_title() {
        return esc_html__( "Osteo Accordion", 'osteo-accordion' );
    }

    public function get_icon() {
        return 'eicon-accordion';
    }

    public function get_keywords() {
        return ['accordion', 'answer', 'accordions', 'question'];
    }

    public function get_categories() {
        return array( 'basic' );
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'accordion_content',
            [
                'label' => esc_html__( 'Content', 'osteo-accordion' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'accordion_style',
            [
                'label'       => esc_html__( 'Accordion Style', 'osteo-accordion' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => 'style-1',
                'label_block' => false,
                'options'     => [
                    'style-1'  => esc_html__( 'Style 1', 'osteo-accordion' ),
                    'style-2'  => esc_html__( 'Style 2', 'osteo-accordion' ),
                    'style-3'  => esc_html__( 'Style 3', 'osteo-accordion' ),
                    'style-4'  => esc_html__( 'Style 4', 'osteo-accordion' ),
                    'style-5'  => esc_html__( 'Style 5', 'osteo-accordion' ),
                    'style-6'  => esc_html__( 'Style 6', 'osteo-accordion' ),
                    'style-7'  => esc_html__( 'Style 7', 'osteo-accordion' ),
                    'style-8'  => esc_html__( 'Style 8', 'osteo-accordion' ),
                    'style-9'  => esc_html__( 'Style 9', 'osteo-accordion' ),
                    'style-10' => esc_html__( 'Style 10', 'osteo-accordion' ),
                    'style-11' => esc_html__( 'Style 11', 'osteo-accordion' ),
                    'style-12' => esc_html__( 'Style 12', 'osteo-accordion' ),
                    'style-13' => esc_html__( 'Style 13', 'osteo-accordion' ),
                    'style-14' => esc_html__( 'Style 14', 'osteo-accordion' ),
                    'style-15' => esc_html__( 'Style 15', 'osteo-accordion' ),
                    'style-16' => esc_html__( 'Style 16', 'osteo-accordion' ),
                    'style-17' => esc_html__( 'Style 17', 'osteo-accordion' ),
                    'style-18' => esc_html__( 'Style 18', 'osteo-accordion' ),
                    'style-19' => esc_html__( 'Style 19', 'osteo-accordion' ),
                    'style-20' => esc_html__( 'Style 20', 'osteo-accordion' ),
                    'style-21' => esc_html__( 'Style 21', 'osteo-accordion' ),
                    'style-22' => esc_html__( 'Style 22', 'osteo-accordion' ),
                    'style-23' => esc_html__( 'Style 23', 'osteo-accordion' ),
                    'style-24' => esc_html__( 'Style 24', 'osteo-accordion' ),
                    'style-25' => esc_html__( 'Style 25', 'osteo-accordion' ),
                    'style-26' => esc_html__( 'Style 26', 'osteo-accordion' ),
                    'style-27' => esc_html__( 'Style 27', 'osteo-accordion' ),
                    'style-28' => esc_html__( 'Style 28', 'osteo-accordion' ),
                    'style-29' => esc_html__( 'Style 29', 'osteo-accordion' ),
                    'style-30' => esc_html__( 'Style 30', 'osteo-accordion' ),
                    'style-31' => esc_html__( 'Style 31', 'osteo-accordion' ),
                    'style-32' => esc_html__( 'Style 32', 'osteo-accordion' ),
                    'style-33' => esc_html__( 'Style 33', 'osteo-accordion' ),
                    'style-34' => esc_html__( 'Style 34', 'osteo-accordion' ),
                    'style-35' => esc_html__( 'Style 35', 'osteo-accordion' ),
                    'style-36' => esc_html__( 'Style 36', 'osteo-accordion' ),
                    'style-37' => esc_html__( 'Style 37', 'osteo-accordion' ),
                    'style-38' => esc_html__( 'Style 38', 'osteo-accordion' ),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->start_controls_tabs( 'tabs_accordion_content_field' );

        $repeater->start_controls_tab(
            'accordion_content_tab',
            [
                'label' => esc_html__( 'Content', 'osteo-accordion' ),
            ]
        );

        $repeater->add_control(
            'accordion_active',
            [
                'label'        => esc_html__( 'Accordion Open', 'osteo-accordion' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'osteo-accordion' ),
                'label_off'    => esc_html__( 'Hide', 'osteo-accordion' ),
                'return_value' => 'active',
                'default'      => 'no',
            ]
        );

        $repeater->add_control(
            'accordion_heading',
            [
                'label'       => esc_html__( 'Heading', 'osteo-accordion' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'accordion_image',
            [
                'label'       => esc_html__( 'Choose Image', 'osteo-accordion' ),
                'description' => esc_html__( 'Note: Image Works for Only Style 29 to Style 38', 'osteo-accordion' ),
                'type'        => \Elementor\Controls_Manager::MEDIA,
                'default'     => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'accordion_paragraph',
            [
                'label'   => esc_html__( 'Paragraph', 'osteo-accordion' ),
                'type'    => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Consectetur non accusantium obcaecati et ducimus consequatur possimus cumque necessitatibus, dolores id architecto nobis qui magnam iure optio maxime ad culpa, odit dolorem. Expedita illo eius deleniti in ipsam voluptas dolorum quaerat.', 'osteo-accordion' ),
            ]
        );

        $repeater->add_control(
            'accordion_close_icon',
            [
                'label'   => esc_html__( 'Accordion Close Icon', 'osteo-accordion' ),
                'type'    => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-plus',
                    'library' => 'solid',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_open_icon',
            [
                'label'   => esc_html__( 'Accordion Open Icon', 'osteo-accordion' ),
                'type'    => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-minus',
                    'library' => 'solid',
                ],
            ]
        );

        $repeater->end_controls_tab();

        //Style Tab
        $repeater->start_controls_tab(
            'accordion_style_tab',
            [
                'label' => esc_html__( 'Style', 'osteo-accordion' ),
            ]
        );

        $repeater->add_control(
            'accordion_heading_options',
            [
                'label' => esc_html__( 'Heading Options', 'osteo-accordion' ),
                'type'  => \Elementor\Controls_Manager::HEADING,
            ]
        );

        $repeater->add_control(
            'accordion_heading_color',
            [
                'label'     => esc_html__( 'Color', 'osteo-accordion' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'        => 'accordion_heading_background',
                'description' => esc_html__( 'Note: Background Color Works for Only Style 1 to Style 14', 'osteo-accordion' ),
                'label'       => esc_html__( 'Background', 'osteo-accordion' ),
                'types'       => ['classic', 'gradient'],
                'selector'    => '{{WRAPPER}} .osteo-accordion-style-1 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-2 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-3 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-4 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-5 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-6 {{CURRENT_ITEM}} .accordion-head,  .osteo-accordion-style-7 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-8 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-9 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-10 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-11 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-12 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-13 {{CURRENT_ITEM}} .accordion-head, .osteo-accordion-style-14 {{CURRENT_ITEM}} .accordion-head',
            ]
        );

        $repeater->add_control(
            'accordion_heading_color_hover',
            [
                'label'     => esc_html__( 'Color (Hover)', 'osteo-accordion' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head:hover h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'        => 'accordion_heading_background_hover',
                'description' => esc_html__( 'Note: Background Color Works for Only Style 1 to Style 14', 'osteo-accordion' ),
                'label'       => esc_html__( 'Background', 'osteo-accordion' ),
                'types'       => ['classic', 'gradient'],
                'selector'    => '{{WRAPPER}} .osteo-accordion-style-1 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-2 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-3 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-4 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-5 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-6 {{CURRENT_ITEM}} .accordion-head:hover,  .osteo-accordion-style-7 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-8 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-9 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-10 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-11 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-12 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-13 {{CURRENT_ITEM}} .accordion-head:hover, .osteo-accordion-style-14 {{CURRENT_ITEM}} .accordion-head:hover',
            ]
        );

        $repeater->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'accordion_heading_typography',
                'label'    => esc_html__( 'Typography', 'osteo-accordion' ),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head h2',
            ]
        );

        $repeater->add_control(
            'accordion_heading_padding',
            [
                'label'      => esc_html__( 'Padding', 'osteo-accordion' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_heading_margin',
            [
                'label'      => esc_html__( 'Margin', 'osteo-accordion' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .osteo-accordion-style-1 {{CURRENT_ITEM}}'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-2 {{CURRENT_ITEM}}'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-3 {{CURRENT_ITEM}}'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-4 {{CURRENT_ITEM}}'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-5 {{CURRENT_ITEM}}'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-6 {{CURRENT_ITEM}}'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-7 {{CURRENT_ITEM}}'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-8 {{CURRENT_ITEM}}'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-9 {{CURRENT_ITEM}}'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-10 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-11 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-12 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-13 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-14 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-15 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-16 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-17 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-18 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-19 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-20 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-21 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-22 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-23 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-24 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-25 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-26 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-27 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-28 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-29 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-30 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-31 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-32 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-33 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-34 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-35 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-36 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-37 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-38 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-39 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-40 {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'accordion_heading_box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'osteo-accordion' ),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head',
            ]
        );

        $repeater->add_control(
            'accordion_heading_border_options',
            [
                'label' => esc_html__( 'Heading Border Options', 'osteo-accordion' ),
                'type'  => \Elementor\Controls_Manager::HEADING,
            ]
        );

        $repeater->add_control(
            'accordion_heading_border_special',
            [
                'label'       => esc_html__( 'Special Border', 'osteo-accordion' ),
                'description' => esc_html__( 'Note: Special Border Works for Only Style 3 to Style 10 and Style 17 to Style 24', 'osteo-accordion' ),
                'type'        => Controls_Manager::SLIDER,
                'range'       => [
                    'px' => [
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'default'     => [
                    'size' => 4,
                ],
                'selectors'   => [
                    '{{WRAPPER}} .osteo-accordion-style-3 {{CURRENT_ITEM}} .accordion-head'  => 'border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-4 {{CURRENT_ITEM}} .accordion-head'  => 'border-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-5 {{CURRENT_ITEM}} .accordion-head'  => 'border-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-6 {{CURRENT_ITEM}} .accordion-head'  => 'border-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-7 {{CURRENT_ITEM}} .accordion-head'  => 'border-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-8 {{CURRENT_ITEM}} .accordion-head'  => 'border-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-9 {{CURRENT_ITEM}} .accordion-head'  => 'border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-9 {{CURRENT_ITEM}} .accordion-body'  => 'border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-10 {{CURRENT_ITEM}} .accordion-head' => 'border-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-10 {{CURRENT_ITEM}} .accordion-body' => 'border-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-17 {{CURRENT_ITEM}} .accordion-head' => 'border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-18 {{CURRENT_ITEM}} .accordion-head' => 'border-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-19 {{CURRENT_ITEM}} .accordion-head' => 'border-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-20 {{CURRENT_ITEM}} .accordion-head' => 'border-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-21 {{CURRENT_ITEM}} .accordion-head' => 'border-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-22 {{CURRENT_ITEM}} .accordion-head' => 'border-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-23 {{CURRENT_ITEM}} .accordion-head' => 'border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-23 {{CURRENT_ITEM}} .accordion-body' => 'border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-24 {{CURRENT_ITEM}} .accordion-head' => 'border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-24 {{CURRENT_ITEM}} .accordion-body' => 'border-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_heading_border_special_color',
            [
                'label'       => esc_html__( 'Color', 'osteo-accordion' ),
                'description' => esc_html__( 'Note: Special Border Color Works for Only Style 3 to Style 10 and Style 17 to Style 24', 'osteo-accordion' ),
                'type'        => \Elementor\Controls_Manager::COLOR,
                'selectors'   => [
                    '{{WRAPPER}} .osteo-accordion-style-3 {{CURRENT_ITEM}} .accordion-head'  => 'border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-4 {{CURRENT_ITEM}} .accordion-head'  => 'border-right-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-5 {{CURRENT_ITEM}} .accordion-head'  => 'border-bottom-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-6 {{CURRENT_ITEM}} .accordion-head'  => 'border-bottom-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-7 {{CURRENT_ITEM}} .accordion-head'  => 'border-top-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-8 {{CURRENT_ITEM}} .accordion-head'  => 'border-top-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-9 {{CURRENT_ITEM}} .accordion-head'  => 'border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-9 {{CURRENT_ITEM}} .accordion-body'  => 'border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-10 {{CURRENT_ITEM}} .accordion-head' => 'border-right-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-10 {{CURRENT_ITEM}} .accordion-body' => 'border-right-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-17 {{CURRENT_ITEM}} .accordion-head' => 'border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-18 {{CURRENT_ITEM}} .accordion-head' => 'border-right-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-19 {{CURRENT_ITEM}} .accordion-head' => 'border-bottom-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-20 {{CURRENT_ITEM}} .accordion-head' => 'border-bottom-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-21 {{CURRENT_ITEM}} .accordion-head' => 'border-top-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-22 {{CURRENT_ITEM}} .accordion-head' => 'border-top-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-23 {{CURRENT_ITEM}} .accordion-head' => 'border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-23 {{CURRENT_ITEM}} .accordion-body' => 'border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-24 {{CURRENT_ITEM}} .accordion-head' => 'border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-24 {{CURRENT_ITEM}} .accordion-body' => 'border-left-color: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_heading_border',
            [
                'label'       => esc_html__( 'Border', 'osteo-accordion' ),
                'description' => esc_html__( 'Note: Border Works for Only Style 15 to Style 28 and Style 35 to Style 38', 'osteo-accordion' ),
                'type'        => Controls_Manager::SLIDER,
                'range'       => [
                    'px' => [
                        'max'  => 5,
                        'step' => 1,
                    ],
                ],
                'default'     => [
                    'size' => 4,
                ],
                'selectors'   => [
                    '{{WRAPPER}} .osteo-accordion-style-15 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-15 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-16 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-16 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-17 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-17 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-18 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-18 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-19 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-19 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-20 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-20 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-21 {{CURRENT_ITEM}} .accordion-head'                        => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-21 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-22 {{CURRENT_ITEM}} .accordion-head'                        => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-22 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-23 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-23 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-24 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-24 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-25 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-25 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-25 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-25 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-26 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-26 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-26 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-26 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-27 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-27 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-27 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-27 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-28 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-28 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-28 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-28 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-35 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-35 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-36 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-36 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-37 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-37 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-38 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-38 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top: {{SIZE}}{{UNIT}}; border-right: {{SIZE}}{{UNIT}}; border-bottom: {{SIZE}}{{UNIT}}; border-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_heading_border_color',
            [
                'label'       => esc_html__( 'Color', 'osteo-accordion' ),
                'description' => esc_html__( 'Note: Border Color Works for Only Style 15 to Style 28 and Style 35 to Style 38', 'osteo-accordion' ),
                'type'        => \Elementor\Controls_Manager::COLOR,
                'selectors'   => [
                    '{{WRAPPER}} .osteo-accordion-style-15 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-15 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-16 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-16 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-17 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-17 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-18 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-18 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-19 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-19 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-20 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-20 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-21 {{CURRENT_ITEM}} .accordion-head'                        => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-21 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-22 {{CURRENT_ITEM}} .accordion-head'                        => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-22 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-23 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-23 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-24 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-24 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-25 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-25 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-25 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-25 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-26 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-26 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-26 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-26 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-27 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-27 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-27 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-27 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-28 {{CURRENT_ITEM}} .accordion-head'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-28 {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-28 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-28 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-35 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-35 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-36 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-36 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-37 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-37 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-38 {{CURRENT_ITEM}} .accordion-close'                       => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-38 {{CURRENT_ITEM}} .accordion-open'                        => 'border-top-color: {{VALUE}}; border-right-color: {{VALUE}}; border-bottom-color: {{VALUE}}; border-left-color: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_paragraph_options',
            [
                'label'     => esc_html__( 'Paragraph Options', 'osteo-accordion' ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'accordion_paragraph_color',
            [
                'label'     => esc_html__( 'Color', 'osteo-accordion' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-body' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_paragraph_background',
            [
                'label'     => esc_html__( 'Background', 'osteo-accordion' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-body' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'accordion_paragraph_typography',
                'label'    => esc_html__( 'Typography', 'osteo-accordion' ),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-body',
            ]
        );

        $repeater->add_control(
            'accordion_paragraph_padding',
            [
                'label'      => esc_html__( 'Padding', 'osteo-accordion' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head.active+.accordion-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'accordion_paragraph_box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'osteo-accordion' ),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-body',
            ]
        );

        $repeater->add_control(
            'accordion_icon_options',
            [
                'label'     => esc_html__( 'Accordion Close/Open Icon', 'osteo-accordion' ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'accordion_close_open_icon_font_size',
            [
                'label'     => esc_html__( 'Icon Size', 'osteo-accordion' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'default'   => [
                    'size' => 28,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head .accordion-close i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head .accordion-open i'  => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_close_open_icon_color',
            [
                'label'     => esc_html__( 'Color', 'osteo-accordion' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head .accordion-close i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head .accordion-open i'  => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_close_open_icon_background',
            [
                'label'       => esc_html__( 'Background', 'osteo-accordion' ),
                'description' => esc_html__( 'Note: Background Color Works for Only Style 11 to Style 14 and Style 31 to Style 34', 'osteo-accordion' ),
                'type'        => \Elementor\Controls_Manager::COLOR,
                'selectors'   => [
                    '{{WRAPPER}} .osteo-accordion-style-11 {{CURRENT_ITEM}} .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-11 {{CURRENT_ITEM}} .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-12 {{CURRENT_ITEM}} .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-12 {{CURRENT_ITEM}} .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-13 {{CURRENT_ITEM}} .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-13 {{CURRENT_ITEM}} .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-14 {{CURRENT_ITEM}} .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-14 {{CURRENT_ITEM}} .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-31 {{CURRENT_ITEM}} .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-31 {{CURRENT_ITEM}} .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-32 {{CURRENT_ITEM}} .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-32 {{CURRENT_ITEM}} .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-33 {{CURRENT_ITEM}} .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-33 {{CURRENT_ITEM}} .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-34 {{CURRENT_ITEM}} .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-34 {{CURRENT_ITEM}} .accordion-open'  => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_close_open_icon_color_hover',
            [
                'label'     => esc_html__( 'Color (Hover)', 'osteo-accordion' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head:hover .accordion-close i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .accordion-head:hover .accordion-open i'  => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_close_open_icon_background_hover',
            [
                'label'       => esc_html__( 'Background (Hover)', 'osteo-accordion' ),
                'description' => esc_html__( 'Note: Background Color Works for Only Style 11 to Style 14 and Style 31 to Style 34', 'osteo-accordion' ),
                'type'        => \Elementor\Controls_Manager::COLOR,
                'selectors'   => [
                    '{{WRAPPER}} .osteo-accordion-style-11 {{CURRENT_ITEM}} .accordion-head:hover .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-11 {{CURRENT_ITEM}} .accordion-head:hover .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-12 {{CURRENT_ITEM}} .accordion-head:hover .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-12 {{CURRENT_ITEM}} .accordion-head:hover .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-13 {{CURRENT_ITEM}} .accordion-head:hover .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-13 {{CURRENT_ITEM}} .accordion-head:hover .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-14 {{CURRENT_ITEM}} .accordion-head:hover .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-14 {{CURRENT_ITEM}} .accordion-head:hover .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-31 {{CURRENT_ITEM}} .accordion-head:hover .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-31 {{CURRENT_ITEM}} .accordion-head:hover .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-32 {{CURRENT_ITEM}} .accordion-head:hover .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-32 {{CURRENT_ITEM}} .accordion-head:hover .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-33 {{CURRENT_ITEM}} .accordion-head:hover .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-33 {{CURRENT_ITEM}} .accordion-head:hover .accordion-open'  => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-34 {{CURRENT_ITEM}} .accordion-head:hover .accordion-close' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .osteo-accordion-style-34 {{CURRENT_ITEM}} .accordion-head:hover .accordion-open'  => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $repeater->end_controls_tab();

        $repeater->end_controls_tabs();

        $this->add_control(
            'accordion_list',
            [
                'label'       => esc_html__( 'Single Timeline', 'osteo-accordion' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'accordion_heading' => esc_html__( 'Welcome to Installing Osteo Accordion', 'osteo-accordion' ),
                    ],
                    [
                        'accordion_heading' => esc_html__( 'Fully Responsive for Any Devices', 'osteo-accordion' ),
                    ],
                    [
                        'accordion_heading' => esc_html__( 'Perfectly Work With Any Theme', 'osteo-accordion' ),
                    ],
                    [
                        'accordion_heading' => esc_html__( 'Lightweight and Easy to Customize', 'osteo-accordion' ),
                    ],
                ],
                'title_field' => '{{accordion_heading}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'accordion_stylesheet',
            [
                'label' => esc_html__( 'Style', 'osteo-accordion' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'accordion_close_open_icon_transition',
            [
                'label'     => esc_html__( 'Transition', 'osteo-accordion' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'max'  => 1.0,
                        'step' => 0.1,
                    ],
                ],
                'default'   => [
                    'size' => 0.4,
                ],
                'selectors' => [
                    '{{WRAPPER}} .accordion-body' => 'transition: all {{SIZE}}s;',
                ],
            ]
        );

        $this->add_control(
            'accordion_image_height',
            [
                'label'     => esc_html__( 'Image Height', 'osteo-accordion' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'max'  => 1000,
                        'step' => 20,
                    ],
                ],
                'default'   => [
                    'size' => 300,
                ],
                'selectors' => [
                    '{{WRAPPER}} .osteo-accordion-style-29 .accordion-head' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-30 .accordion-head' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-31 .accordion-head' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-32 .accordion-head' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-33 .accordion-head' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-34 .accordion-head' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-35 .accordion-head' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-36 .accordion-head' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-37 .accordion-head' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .osteo-accordion-style-38 .accordion-head' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'accordion_style' => ['style-29', 'style-30', 'style-31', 'style-32', 'style-33', 'style-34', 'style-35', 'style-36', 'style-37', 'style-38'],
                ],
            ]
        );

        $this->add_control(
            'accordion_image_background',
            [
                'label'     => esc_html__( 'Image Opacity Color', 'plugin-name' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .osteo-accordion-style-29 .accordion-head:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-30 .accordion-head:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-31 .accordion-head:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-32 .accordion-head:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-33 .accordion-head:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-34 .accordion-head:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-35 .accordion-head:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-36 .accordion-head:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-37 .accordion-head:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .osteo-accordion-style-38 .accordion-head:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'accordion_image_opacity',
            [
                'label'     => esc_html__( 'Image Opacity', 'osteo-accordion' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'max'  => .9,
                        'step' => .1,
                    ],
                ],
                'default'   => [
                    'size' => .3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .osteo-accordion-style-29 .accordion-head:before' => 'opacity: {{SIZE}};',
                    '{{WRAPPER}} .osteo-accordion-style-30 .accordion-head:before' => 'opacity: {{SIZE}};',
                    '{{WRAPPER}} .osteo-accordion-style-31 .accordion-head:before' => 'opacity: {{SIZE}};',
                    '{{WRAPPER}} .osteo-accordion-style-32 .accordion-head:before' => 'opacity: {{SIZE}};',
                    '{{WRAPPER}} .osteo-accordion-style-33 .accordion-head:before' => 'opacity: {{SIZE}};',
                    '{{WRAPPER}} .osteo-accordion-style-34 .accordion-head:before' => 'opacity: {{SIZE}};',
                    '{{WRAPPER}} .osteo-accordion-style-35 .accordion-head:before' => 'opacity: {{SIZE}};',
                    '{{WRAPPER}} .osteo-accordion-style-36 .accordion-head:before' => 'opacity: {{SIZE}};',
                    '{{WRAPPER}} .osteo-accordion-style-37 .accordion-head:before' => 'opacity: {{SIZE}};',
                    '{{WRAPPER}} .osteo-accordion-style-38 .accordion-head:before' => 'opacity: {{SIZE}};',
                ],
                'condition' => [
                    'accordion_style' => ['style-29', 'style-30', 'style-31', 'style-32', 'style-33', 'style-34', 'style-35', 'style-36', 'style-37', 'style-38'],
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        ?>

        <?php if ( 'style-1' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-1">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-2' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-2">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-3' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-3">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-4' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-4">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-5' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-5">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-6' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-6">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-7' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-7">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-8' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-8">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-9' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-9">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-10' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-10">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-11' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-11">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-12' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-12">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-13' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-13">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-14' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-14">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-15' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-15">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-16' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-16">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-17' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-17">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-18' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-18">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-19' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-19">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-20' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-20">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-21' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-21">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-22' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-22">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-23' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-23">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-24' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-24">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-25' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-25">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-26' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-26">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-27' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-27">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-28' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-28">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-29' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-29">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>" style="background-image: url(<?php echo esc_url( $item['accordion_image']['url'] ); ?>);">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-30' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-30">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>" style="background-image: url(<?php echo esc_url( $item['accordion_image']['url'] ); ?>);">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-31' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-31">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>" style="background-image: url(<?php echo esc_url( $item['accordion_image']['url'] ); ?>);">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-32' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-32">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>" style="background-image: url(<?php echo esc_url( $item['accordion_image']['url'] ); ?>);">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-33' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-33">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>" style="background-image: url(<?php echo esc_url( $item['accordion_image']['url'] ); ?>);">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-34' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-34">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>" style="background-image: url(<?php echo esc_url( $item['accordion_image']['url'] ); ?>);">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-35' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-35">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>" style="background-image: url(<?php echo esc_url( $item['accordion_image']['url'] ); ?>);">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-36' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-36">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>" style="background-image: url(<?php echo esc_url( $item['accordion_image']['url'] ); ?>);">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-37' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-37">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>" style="background-image: url(<?php echo esc_url( $item['accordion_image']['url'] ); ?>);">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php elseif ( 'style-38' === $settings['accordion_style'] ): ?>

            <div class="osteo-accordion-style-38">
                <div class="accordion">
                    <?php foreach ( $settings['accordion_list'] as $item ): ?>
                    <div class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?> accordion-content">
                        <div class="accordion-head <?php echo esc_html( $item['accordion_active'] ); ?>" style="background-image: url(<?php echo esc_url( $item['accordion_image']['url'] ); ?>);">
                            <h2><?php echo esc_html( $item['accordion_heading'] ); ?></h2>
                            <span class="accordion-close">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_close_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                            <span class="accordion-open">
                                <?php \Elementor\Icons_Manager::render_icon( $item['accordion_open_icon'], ['aria-hidden' => 'true'] );?>
                            </span>
                        </div>
                        <div class="accordion-body">
                            <?php echo $item['accordion_paragraph']; ?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>

        <?php endif;?>

		<?php
}
}